import 'package:absenkuv3/Repository/Model/MonitorAbsen/mBadgeMonitorAbsen.dart';
import 'package:absenkuv3/Repository/Service/MonitorAbsensi/badgeMonitorAbsenApi.dart';
import 'package:flutter/material.dart';
import 'package:flutter_bloc/flutter_bloc.dart';

abstract class BadgeMonitorAbsenEvent {
  BuildContext? context;
  GlobalKey<ScaffoldState>? scaffoldKey;
}

abstract class BadgeMonitorAbsenState {}

class GetBadgeMonitorAbsen extends BadgeMonitorAbsenEvent {
  GetBadgeMonitorAbsen(
    BuildContext _context,
  ) {
    context = _context;
  }
}

class GetSuccessBadgeMonitor extends BadgeMonitorAbsenState {
  BadgeMonitorAbsen? dataColumn;
  GetSuccessBadgeMonitor(this.dataColumn) {}
}

class GetBadgeMonitorProgress extends BadgeMonitorAbsenState {}

class GetFailed extends BadgeMonitorAbsenState {}

class BadgeMonitorAbsenBloc
    extends Bloc<BadgeMonitorAbsenEvent, BadgeMonitorAbsenState> {
  BadgeMonitorAbsenBloc(BadgeMonitorAbsenState initialState)
      : super(initialState);

  @override
  Stream<BadgeMonitorAbsenState> mapEventToState(
      BadgeMonitorAbsenEvent event) async* {
    if (event is GetBadgeMonitorAbsen) {
      // yield GetBadgeMonitorProgress();
      BadgeMonitorAbsen dashboardRespon =
          await BadgeMonitorAbsenApi().badgeMonitorAbsen();
      if (dashboardRespon.success!)
        yield GetSuccessBadgeMonitor(dashboardRespon);
      else
        yield GetFailed();
    }
  }
}
